; -------- Defaults
Prog?Name      = Wc3 CTGen
Prog?Ver       = 0.0.1
Prog?FullName  = %Prog?Name% v%Prog?Ver%
Win?W          = 400
Win?H          = 400
Win?Title      = %Prog?FullName% - Main
IsPreviewOn    = 0
BgColor        = ffffff
FgColor        = 000000
BgImg          = none
; -------- Main Gui
MainMenu()
gui, +LastFound +resize
gui, add, edit, x0 y0 w%Win?W% h%Win?H% vEdit,
hWnd:=WinExist()
IEWnd:=IE_Add(hWnd,0,0,Win?W,Win?H)
gui, show, w%Win?W% h%Win?H%, %Win?Title%
control, hide,,,ahk_id %IEWnd%
return
; -------- Subs
mmTogglePreview:
Preview_Toggle()
return

mmBgHandler:
;# clear all the menus
Menu, ViewMenu, UnCheck, Use White Background
Menu, ViewMenu, UnCheck, Use Black Background
Menu, ViewMenu, UnCheck, Use Custom Background
;# check selected menu
Menu, ViewMenu, Check, %A_ThisMenuItem%
If A_ThisMenuItem = Use White Background
{
  BgColor=ffffff
}
else if A_ThisMenuItem = Use Black Background
{
  BgColor=000000
}
else if A_ThisMenuItem = Use Custom Background
{
  ChoseColor:=ChooseColor()
  IfNotEqual,ChoseColor,-1,SetEnv,BgColor,%ChoseColor%
}
return

mmFgHandler:
Menu, ViewMenu, UnCheck, Use White Foreground
Menu, ViewMenu, UnCheck, Use Black Foreground
Menu, ViewMenu, UnCheck, Use Default Yellow Foreground
Menu, ViewMenu, UnCheck, Use Custom Forground
Menu, ViewMenu, Check, %A_ThisMenuItem%
IfEqual,A_ThisMenuItem,Use White Foreground,SetEnv,FgColor,ffffff
IfEqual,A_ThisMenuItem,Use Black Foreground,SetEnv,FgColor,000000
IfEqual,A_ThisMenuItem,Use Default Yellow Foreground,SetEnv,FgColor,ffcc00
If A_ThisMenuItem = Use Custom Foreground
{
  ChoseColor:=ChooseColor()
  IfNotEqual,ChoseColor,-1,SetEnv,FgColor,%ChoseColor%
}
return

mmPickColor:
Color:=ChooseColor()
If Color != -1
{
  guicontrol, focus, Edit
  OldClip:=Clipboard
  Clipboard:="|cff" . Color . "|r"
  Send,^v
  Clipboard:=OldClip
  Send,{left 2}
}
return
mmBgImgHandler:
Menu,BgImgMenu, Uncheck, None
Menu,BgImgMenu, Uncheck, Use Water Background
Menu,BgImgMenu, Uncheck, Use Snow Background
Menu,BgImgMenu, Uncheck, Use Grass Background
Menu,BgImgMenu, Uncheck, Use Loadscreen Background

Menu, BgImgMenu, Check, %A_ThisMenuItem%
IfEqual,A_ThisMenuItem,None,SetEnv,BgImg,None
IfEqual,A_ThisMenuItem,Use Water Background,SetEnv,BgImg,%A_ScriptDir%\inc\BgWater.gif
IfEqual,A_ThisMenuItem,Use Snow Background,SetEnv,BgImg,%A_ScriptDir%\inc\BgSnow.gif
IfEqual,A_ThisMenuItem,Use Grass Background,SetEnv,BgImg,%A_ScriptDir%\inc\BgGrass.gif
IfEqual,A_ThisMenuItem,Use Water Background,SetEnv,BgImg,%A_ScriptDir%\inc\BgLoad.gif
Msgbox, BgImg: %BgImg%
return

mmMakeGrad:
LB_BuildGui("inc\GuiScript.lbp")
return

DefineLeftGrad:
LeftColor:=ChooseColor()
IfNotEqual,LeftColor,-1,guicontrol,2:,LeftColor,%LeftColor%
return

DefineRightGrad:
RightColor:=ChooseColor()
IfNotEqual,RightColor,-1,guicontrol,2:,RightColor,%RightColor%
return

GenerateGrad:
gui, submit, nohide
;txt,start,end
GradText:=MakeHexGradient(GradTextEdit,LeftColor,RightColor)
guicontrol,2:,GradTextEdit,%GradText%
return

GuiClose:
Msgbox, 4, Are you sure?, Are you sure you want to exit the program?
IfMsgbox Yes
{
  ExitApp
}
return

2GuiClose:
gui, 2: destroy
return

; - Resize
GuiSize:
IE_Move(IEWnd,0,0,A_GuiWidth,A_GuiHeight)
guicontrol, Move, Edit, x0 y0 w%A_GuiWidth% h%A_GuiHeight%
return
; -------- Functions
; - Main Menu VOID
MainMenu()
{
  ; - FileMenu
  
  ; - EditMenu
  Menu, EditMenu, Add, Choose A Color, mmPickColor
  Menu, EditMenu, Add, Make Gradient Text, mmMakeGrad
  ; - ViewMenu
  Menu, ViewMenu, Add, Preview, mmTogglePreview
  Menu, ViewMenu, Add
  Menu, ViewMenu, Add, Use White Background, mmBgHandler
  Menu, ViewMenu, Add, Use Black Background, mmBgHandler
  Menu, ViewMenu, Add, Use Custom Background, mmBgHandler
  Menu, ViewMenu, Check, Use White Background
    ; - BgImgMenu
    Menu,BgImgMenu, Add, None, mmBgImgHandler
    Menu, BgImgMenu, Add, Use Water Background, mmBgImgHandler
    Menu, BgImgMenu, Add, Use Snow Background, mmBgImgHandler
    Menu, BgImgMenu, Add, Use Grass Background, mmBgImgHandler
    Menu, BgImgMenu, Add, Use Loadscreen Background, mmBgImgHandler
    Menu, BgImgMenu, Check, None
  Menu, ViewMenu, Add, Background Image, :BgImgMenu
  Menu, ViewMenu, Add
  Menu, ViewMenu, Add, Use Black Foreground, mmFgHandler
  Menu, ViewMenu, Add, Use White Foreground, mmFgHandler
  Menu, ViewMenu, Add, Use Default Yellow Foreground, mmFgHandler
  Menu, ViewMenu, Add, Use Custom Forground, mmFgHandler
  Menu, ViewMenu, Check, Use Black Foreground
  ; - MainMenu
  Menu, MainMenu, Add, Edit, :EditMenu
  Menu, MainMenu, Add, View, :ViewMenu
  ; - Add To Gui
  Gui, Menu, MainMenu
  return
}
; - Toggle Preview VOID
Preview_Toggle() {
  global IsPreviewOn
  If IsPreviewOn = 0
  {
    IsPreviewOn = 1
    Menu, ViewMenu, ToggleCheck, Preview
    Menu, ViewMenu, Disable, Use White Background
    Menu, ViewMenu, Disable, Use Black Background
    Menu, ViewMenu, Disable, Use Custom Background
    Menu, ViewMenu, Disable, Background Image
    Preview_Generate()
    Control, Show,,,ahk_id %IEWnd%
    guicontrol, hide, Edit
  }
  else if IsPreviewOn = 1
  {
    IsPreviewOn = 0
    Menu, ViewMenu, ToggleCheck, Preview
    Menu, ViewMenu, Enable, Use White Background
    Menu, ViewMenu, Enable, Use Black Background
    Menu, ViewMenu, Enable, Use Custom Background
    Menu, ViewMenu, Enable, Background Image
    Control, Hide,,,ahk_id %IEWnd%
    guicontrol, Show, Edit
  }
  return
}
; - Generate Preview void
Preview_Generate() {
  gui, submit, nohide
  global BgImg
  global BgColor
  global FgColor
  global edit
  global IEWnd
DocHead=
(
<html>
<head>
<title>Wc3 CTGen Preview</title>
<style type="text/css">
body {
  background:%BgColor%;
  background-image:url(%BgImg%);
  color:#%FgColor%;
  margin:0px 0px 0px 0px;
  font-family:Arial;
}
span {
  font-family:Arial;
}
pre {
  font-family:Arial;
  color:#%FgColor%;
}
</style>
</head>
<body>
<pre>
)
  Transform,HTMLBody,html,%Edit%
  HTMLBody:=RegExReplace(HTMLBody,"i)\|cff[A-F,a-f,0-9]{6,6}", "<span style='color:#$0'>")
  HTMLBody:=RegExReplace(HTMLBody, "i)\|r", "</span>")
  HTMLBody:=RegExReplace(HTMLBody, "i)\|cff", "")
  HTMLBody:=RegExReplace(HTMLBody, "i)\|n", chr(10))
DocFoot=
(
</pre>
</body>
</html>
)
  debugfile=%A_ScriptDir%\inc\Debug.html
  FileDelete,%Debugfile%
  FileAppend,%DocHead%%HTMLBody%%DocFoot%,%DebugFile%
  IE_LoadUrl(IEWnd,DebugFile)
  ;IE_LoadHTML(IEWnd, DocHead . HTMLBody . DocFoot)
  ;msgbox, %DocHead%%HTMLBody%%DocFoot%
  return
}

Convert(Data,Type)
{
	If (Type = "H")
	{
		SetFormat,INTEGER,H
		Data += 0
		SetFormat,INTEGER,D
		StringTrimLeft,Data,Data,2
		DataLength := StrLen(Data)
		If (DataLength = "1")
		{
			Data = 0%Data%
		}
	}
	else
	{
		SetFormat,INTEGER,D
		Data += 0
	}
	return %Data%
}
MakeHexGradient(Text,StartColor,EndColor)
{
	TextLength := StrLen(Text)
	If (TextLength = "1")
	{
		ColoredText = |cff%StartColor%%Text%|r
		return,%ColoredText%
	}
	Loop,3
	{
		StringPos := A_Index * 2 - 1
		StartColor%A_Index% := "0x" . SubStr(StartColor,StringPos,2)
		StartColor%A_Index% := Convert(StartColor%A_Index%,"D")
		EndColor%A_Index% := "0x" . SubStr(EndColor,StringPos,2)
		EndColor%A_Index% := Convert(EndColor%A_Index%,"D")
		Difference%A_index% := EndColor%A_Index% - StartColor%A_Index%
		Difference%A_index% := Difference%A_index% // (TextLength - 2)
	}
	ColoredText := "|cff" . SubStr(StartColor,1,2) . SubStr(StartColor,3,2) . SubStr(StartColor,5,2) . SubStr(Text,1,1)
	If (TextLength = "2")
	{
		ColoredText .= "|cff" . SubStr(EndColor,1,2) . SubStr(EndColor,3,2) . SubStr(EndColor,5,2) . SubStr(Text,2,1) . "|r"
		return,%ColoredText%
	}
	Loop,%TextLength%
	{
		If (A_Index != "1" and A_Index != TextLength)
		{
			Letter := SubStr(Text,A_Index,1)
			Multiplier := A_Index - 1
			Color1 := StartColor1 + (Difference1 * Multiplier)
			Color1 := Convert(Color1,"H")
			Color2 := StartColor2 + (Difference2 * Multiplier)
			Color2 := Convert(Color2,"H")
			Color3 := StartColor3 + (Difference3 * Multiplier)
			Color3 := Convert(Color3,"H")
			ColoredText .= "|cff" . Color1 . Color2 . Color3 . Letter
		}
	}
	ColoredText .= "|cff" . SubStr(EndColor,1,2) . SubStr(EndColor,3,2) . SubStr(EndColor,5,2) . SubStr(Text,TextLength,1) . "|r"
	return,%ColoredText%
}
; -------- Includes
#Include inc\GuiScript.lbf
#include inc\IEControl.ahk
#include inc\CoHelper.ahk
#include inc\ColorPicker.ahk
